<?php 
    include "../include/includeBaseComponenti.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
    
    $idForm = filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT);
    $form = $geecomDb->leggiSingolaRiga("geec_form",$idForm);
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $parametriRicerca = $cerca!="" ? array("testo"=>$cerca,"idForm"=>$idForm) : array("idForm"=>$idForm);
    $parametri = array("tabella"=>"geec_messaggiForm", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"elencoMessaggi.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione di Geecom CMS - elenco messaggi form</title>

    <?php
        include "../include/cssBaseComponenti.php";
    ?>
</head>

<body>
   
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
        
    ?>
    

    <main role="main" class="bg-light">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <?php
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==1) {
                                    echo"<p class=\"alert alert-success\">Utente creato</p>";
                            }
                            else if($_GET["status"]==2) {
                                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
                            }
                            else if($_GET["status"]==4) {
                                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                            }
                            else if($_GET["status"]==400) {
                                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                            }
                            else { //status = 5
                                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                            }
                        }
                    ?>
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <div class="d-md-flex justify-content-between">
                                <h6 class="align-self-center my-0">Messaggi ricevuti da <strong><?php echo $form["nome"] ?></strong></h6>
                                <a class="btn btn-outline-primary mt-2 mt-md-0" href="creaForm.php?id=<?php echo $idForm ?>"><i class="fas fa-arrow-left mr-2"></i>Torna alla form</a>
                            </div>
                        </div>
                        <div class="panel panel-default">
                            <div class="card-body collapse show">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca,array("id"=>$idForm));
                                        $ricerca->stampaFormRicerca($cerca,array("id"=>$idForm));
                                    ?>
                                </div>
                                <div class="table-responsive">
                                    <?php
                                        if(isset($_GET["pag"])) {
                                            $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                        }
                                        else {
                                            $ris = $ricerca->eseguiRicerca(1);
                                        }

                                        $colonne = array("ID","Testo","Data creazione","");
                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        $tabella->setTipo("normale");
                                        while($form = $ris->fetch_assoc()) {
                                            $testoEscape   = filter_var($form["testo"],FILTER_SANITIZE_ADD_SLASHES);
                                            $dataCreazione = date("d/m/Y",strtotime($form["dataCreazione"]));
                                            $azioni        = array("elimina"=>"eliminaOccorrenza({$form["id"]},'$testoEscape')");
                                            $tabella->aggiungiNuovaRiga(array($form["id"],"{$form["testo"]}",$dataCreazione),$azioni);
                                        }

                                        $tabella->stampa("messaggioForm", 0);
                                        $ricerca->stampaPaginazione(true,"elencoMessaggi.php");
                                    ?>
                                </div>
                            </div>
                            <!-- /tabella -->
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
    
    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
                
        include "../../include/modal/modalMenuComponenti.php";
        
        include "../../include/modal/operazioneCompletata.php";

        include "../include/jsBaseComponenti.php";

    ?>
    <div class="modal fade" id="modalEliminaOccorrenza" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare il messaggio?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                <div class="modal-body">
                    <div id="nomeElementoDaEliminare"></div>
                    <input type="text" class="d-none" id="elementoDaEliminare">
                </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOrrorrenza()"><i class="fas fa-check"></i> Elimina</button>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">

        function eliminaOccorrenza(id,nome) {
            document.getElementById("elementoDaEliminare").value = id;
            document.getElementById("nomeElementoDaEliminare").innerHTML = nome;
            $('#modalEliminaOccorrenza').modal('show');
        }
        
        function eseguiEliminazioneOrrorrenza() {
            var id = $('#elementoDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"controller/controllerComponente.php",
                data:{
                    operazione:"eliminaMessaggio",
                    id:<?php echo $idForm ?>,
                    idMessaggio:id
                },
                success:function(result) {
                    if(result=="ok") {
                        document.getElementById("messaggioForm"+id).className = "d-none";
                        $('#modalEliminaOccorrenza').modal('hide');
                    }
                    else {
                        alert(result);
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
</body>
</html>